/*
 * Decompiled with CFR 0.152.
 */
package TileMap;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.imageio.ImageIO;

public class Background {
    private BufferedImage image;
    private double x;
    private double y;
    private double dx;
    private double dy;
    private int width;
    private int height;
    private double xscale;
    private double yscale;
    public static boolean stop = false;

    public Background(String s) {
        this(s, 0.1);
    }

    public Background(String s, double d) {
        this(s, d, d);
    }

    public Background(String s, double d1, double d2) {
        try {
            this.image = ImageIO.read(this.getClass().getResourceAsStream(s));
            this.width = this.image.getWidth();
            this.height = this.image.getHeight();
            this.xscale = d1;
            this.yscale = d2;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Background(String s, double ms, int x, int y, int w, int h) {
        try {
            this.image = ImageIO.read(this.getClass().getResourceAsStream(s));
            this.image = this.image.getSubimage(x, y, w, h);
            this.width = this.image.getWidth();
            this.height = this.image.getHeight();
            this.xscale = ms;
            this.yscale = ms;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setPosition(double x, double y) {
        this.x = x * this.xscale % (double)this.width;
        this.y = y * this.yscale % (double)this.height;
    }

    public void setVector(double dx, double dy) {
        this.dx = dx;
        this.dy = dy;
    }

    public void setScale(double xscale, double yscale) {
        this.xscale = xscale;
        this.yscale = yscale;
    }

    public void setDimensions(int i1, int i2) {
        this.width = i1;
        this.height = i2;
    }

    public double getx() {
        return this.x;
    }

    public double gety() {
        return this.y;
    }

    public void update() {
        this.x += this.dx;
        if (stop) {
            this.x -= this.dx;
        }
        while (this.x <= (double)(-this.width)) {
            this.x += (double)this.width;
        }
        while (this.x >= (double)this.width) {
            this.x -= (double)this.width;
        }
        this.y += this.dy;
        if (stop) {
            this.y -= this.dy;
        }
        while (this.y <= (double)(-this.height)) {
            this.y += (double)this.height;
        }
        while (this.y >= (double)this.height) {
            this.y -= (double)this.height;
        }
    }

    public void draw(Graphics2D g) {
        g.drawImage((Image)this.image, (int)this.x, (int)this.y, null);
        if (this.x < 0.0) {
            g.drawImage((Image)this.image, (int)this.x + this.width, (int)this.y, null);
        }
        if (this.x > 0.0) {
            g.drawImage((Image)this.image, (int)this.x - this.width, (int)this.y, null);
        }
        if (this.y < 0.0) {
            g.drawImage((Image)this.image, (int)this.x, (int)this.y + 400, null);
        }
        if (this.y > 0.0) {
            g.drawImage((Image)this.image, (int)this.x, (int)this.y - 400, null);
        }
    }
}

